*The included code reproduces results that appear in the Introduction section of paper: "Factor Endowments, Economic Integration, Sanctions, and Offshores: Evidence from Inward FDI in Russia. Comparative Economic Studies (2022)." doi: 10.1057/s41294-022-00202-6
*Author information (ORCID IDs):
*Andrzej Cieślik: 0000-0002-7834-7384
*Oleg Gurshev: 0000-0003-4532-7819
*
*-----------------------------------------------------------------------------------------------
* MULTILATERAL SAMPLE RESULTS*
* VERIFIED *
drop if year == 2008
rename stock y
egen countrypair = group(parent host)
encode parent, gen (nparent)
encode host, gen (nhost)

eststo clear
global ylist y
global xlist sanct
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)

global xlist sanct LAG_SANCT LAG_LAG_SANCT LAG_LAG_LAG_SANCT LAG_LAG_LAG_LAG_SANCT 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)


drop if host == "Cyprus" | parent == "Cyprus"

global ylist y
global xlist sanct 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)

global xlist sanct LAG_SANCT LAG_LAG_SANCT LAG_LAG_LAG_SANCT LAG_LAG_LAG_LAG_SANCT 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)

drop if host == "Netherlands" | parent == "Netherlands"
drop if host == "Luxembourg" | parent == "Luxembourg"

global ylist y
global xlist sanct 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)

global xlist sanct LAG_SANCT LAG_LAG_SANCT LAG_LAG_LAG_SANCT LAG_LAG_LAG_LAG_SANCT 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)
esttab using gravity_sanctions_final.rtf, se star(+ 0.10 ** 0.05 *** 0.01)
*-------------------------------------------------------
drop if year == 2008
rename stock y
egen countrypair = group(parent host)
encode parent, gen (nparent)
encode host, gen (nhost)

eststo clear
global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA LAG_LAG_LAG_FTA LAG_LAG_LAG_LAG_FTA 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)

drop if host == "Cyprus" | parent == "Cyprus"

global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA LAG_LAG_LAG_FTA LAG_LAG_LAG_LAG_FTA 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)

drop if host == "Netherlands" | parent == "Netherlands"
drop if host == "Luxembourg" | parent == "Luxembourg"

global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA LAG_LAG_LAG_FTA LAG_LAG_LAG_LAG_FTA 
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year countrypair) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)

esttab using gravity_fta_final.rtf, se star(+ 0.10 ** 0.05 *** 0.01)
*-------------------------------------------------------
drop if year == 2008
rename stock y
egen countrypair = group(parent host)
encode parent, gen (nparent)
encode host, gen (nhost)

eststo clear

global ylist y
global xlist cu
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)

global xlist cu LAG_CU LAG_LAG_CU LAG_LAG_LAG_CU LAG_LAG_LAG_LAG_CU
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)

drop if host == "Cyprus" | parent == "Cyprus"

global ylist y
global xlist cu
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)

global xlist cu LAG_CU LAG_LAG_CU LAG_LAG_LAG_CU LAG_LAG_LAG_LAG_CU
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)

drop if host == "Netherlands" | parent == "Netherlands"
drop if host == "Luxembourg" | parent == "Luxembourg"

global ylist y
global xlist cu
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)

global xlist cu LAG_CU LAG_LAG_CU LAG_LAG_LAG_CU LAG_LAG_LAG_LAG_CU
eststo: ppmlhdfe $ylist $xlist if parent != host ,a(nhost#year nparent#year ) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)
esttab using gravity_cu_multilateral.rtf, se star(+ 0.10 ** 0.05 *** 0.01)

*-------------------------------------------------------
*BILATERAL SAMPLE RESULTS*
* RUSSIA ONLY

drop if year == 2008
rename stock y
egen countrypair = group(parent host)
encode parent, gen (nparent)
encode host, gen (nhost)

xtset countrypair year

gen LAG_SANCT = L.sanct
gen LAG_LAG_SANCT = L.LAG_SANCT
gen LAG_FTA = L.fta
gen LAG_LAG_FTA = L.LAG_FTA
gen LAG_CU = L.cu
gen LAG_LAG_CU = L.LAG_CU

replace LAG_SANCT = 0 if LAG_SANCT == .
replace LAG_LAG_SANCT = 0 if LAG_LAG_SANCT == .
replace LAG_FTA = 0 if LAG_FTA == .
replace LAG_LAG_FTA = 0 if LAG_LAG_FTA == .
replace LAG_CU = 0 if LAG_CU == .
replace LAG_LAG_CU = 0 if LAG_LAG_CU == .


eststo clear
global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist if parent != host, a(year host parent) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA
eststo: ppmlhdfe $ylist $xlist , a(year nhost nparent) cluster(countrypair)

drop if host == "Cyprus" | parent == "Cyprus"

global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist , a(year nhost nparent) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA
eststo: ppmlhdfe $ylist $xlist , a(year nhost nparent) cluster(countrypair)

drop if host == "Netherlands" | parent == "Netherlands"
drop if host == "Luxembourg" | parent == "Luxembourg"

global ylist y
global xlist fta
eststo: ppmlhdfe $ylist $xlist , a(year nhost nparent) cluster(countrypair)

global xlist fta LAG_FTA LAG_LAG_FTA
eststo: ppmlhdfe $ylist $xlist , a(year nhost nparent) cluster(countrypair)
esttab, se star(+ 0.10 ** 0.05 *** 0.01)

*-------------------------------------------------------